IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_PROD_TRILHO_EXCESSO_CANCEL_INCLUI_EXCLUI_PENDENCIA]'))
DROP TRIGGER [dbo].[TRG_EST_PROD_TRILHO_EXCESSO_CANCEL_INCLUI_EXCLUI_PENDENCIA]
GO
CREATE TRIGGER [dbo].[TRG_EST_PROD_TRILHO_EXCESSO_CANCEL_INCLUI_EXCLUI_PENDENCIA]
   ON  [dbo].[EST_PROD_TRILHO_EXCESSO_CANCEL]
   FOR INSERT, DELETE
AS 
BEGIN
	SET NOCOUNT ON;
	
	--SE FOI INSERO (CANCELAMENTO), TIRA DA PENDNCIA E ALTERA O STATUS DO TRILHO PARA CANCELADO
	IF EXISTS(SELECT * FROM inserted) 
	BEGIN
		DELETE FROM
			EST_PROD_TRILHO_EXCESSO_PENDENTE
		WHERE
			EXISTS (
				SELECT 
					* 
				FROM 
					inserted 
				WHERE 
					CD_EMP = EST_PROD_TRILHO_EXCESSO_PENDENTE.CD_EMP
					AND CD_FILIAL = EST_PROD_TRILHO_EXCESSO_PENDENTE.CD_FILIAL
					AND CD_CTR = EST_PROD_TRILHO_EXCESSO_PENDENTE.CD_CTR);

		UPDATE
			EST_PROD_TRILHO_EXCESSO
		SET
			STS_TRILHO = 2
		WHERE
			EXISTS (
				SELECT 
					* 
				FROM 
					inserted 
				WHERE 
					CD_EMP = EST_PROD_TRILHO_EXCESSO.CD_EMP
					AND CD_FILIAL = EST_PROD_TRILHO_EXCESSO.CD_FILIAL
					AND CD_CTR = EST_PROD_TRILHO_EXCESSO.CD_CTR);

	END




	--SE FOI DELETE (EXCLUSO DO CANCELAMENTO), VOLTA A PENDNCIA E ALTERA O STATUS DO TRILHO PARA PENDENTE
	IF EXISTS(SELECT * FROM deleted)
	BEGIN
		INSERT INTO
			EST_PROD_TRILHO_EXCESSO_PENDENTE (CD_EMP, CD_FILIAL, CD_CTR)
		SELECT
			CD_EMP,
			CD_FILIAL,
			CD_CTR
		FROM
			deleted;

		UPDATE
			EST_PROD_TRILHO_EXCESSO
		SET
			STS_TRILHO = 0
		WHERE
			EXISTS (
				SELECT 
					* 
				FROM 
					deleted 
				WHERE 
					CD_EMP = EST_PROD_TRILHO_EXCESSO.CD_EMP
					AND CD_FILIAL = EST_PROD_TRILHO_EXCESSO.CD_FILIAL
					AND CD_CTR = EST_PROD_TRILHO_EXCESSO.CD_CTR);
			
	END

END


GO


